#include "Charliplexing.h"
#include "Font.h"


#include "WProgram.h"

/* -----------------------------------------------------------------  */
/** MAIN program Setup
 */
void setup()                    // run once, when the sketch starts
{
  LedSign::Init();
}




/* -----------------------------------------------------------------  */
/** MAIN program Loop
 */
void loop()                     // run over and over again
{
  char scrollPhrase[] = "TEST"; // phrase to display


  int8_t xCoordinateScroller = 0; // starts out at the maximum horiztonal value and works downward, causing the text to scroll leftward
  int8_t characterWidth = 0; // how wide the rendered font letter is
  
  int horizontalWidth = 14; // horizontal width of the lolshield
  int refreshDelay = 80; // seconds to wait in between refreshes (otherwise the message will scroll too fast to see)
  int phraseDelay = 2000; // seconds to wait until starting over after having displayed the whole message
  
  for(int8_t actualXCoordinate = horizontalWidth - 1; actualXCoordinate > -100; actualXCoordinate--) 
  {
    xCoordinateScroller = actualXCoordinate;
    LedSign::Clear();
    
    for(int charIndex = 0; charIndex < sizeof(scrollPhrase); charIndex++) 
    {
      characterWidth = Font::Draw(scrollPhrase[charIndex], xCoordinateScroller, 0);
      xCoordinateScroller += characterWidth;
      
      if (xCoordinateScroller >= horizontalWidth - 1) 
      {
        break;
      }
    }  
    
    delay(refreshDelay);
  }
  
  delay(phraseDelay);
}
